/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.dialogs;

import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;

public class TextDialog
extends AbstractDialog {
    private String header;
    private String text;
    private final Consumer<String> onAccept;
    private final Runnable onClose;
    private Label textHeader;
    private Label textDescription;
    private TextField textField;

    public TextDialog(JavaFXApplication application, String header, String text, Consumer<String> onAccept, Runnable onClose) {
        super("dialogs/text/dialog.fxml", application);
        this.header = header;
        this.text = text;
        this.onAccept = onAccept;
        this.onClose = onClose;
    }

    public void setHeader(String header) {
        this.header = header;
        if (this.isInit()) {
            this.textDescription.setText(this.text);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.isInit()) {
            this.textHeader.setText(this.header);
        }
    }

    @Override
    public String getName() {
        return "text";
    }

    @Override
    protected void doInit() throws Exception {
        this.textHeader = (Label)LookupHelper.lookup((Node)this.layout, "#dialogHeader");
        this.textDescription = (Label)LookupHelper.lookup((Node)this.layout, "#dialogDescription");
        this.textField = (TextField)LookupHelper.lookup((Node)this.layout, "#dialogInput");
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        ((Button)LookupHelper.lookup((Node)this.layout, "#exit")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onClose.run();
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#dialogSend")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onAccept.accept(this.textField.getText());
        });
    }
}

