/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.dialogs;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.client.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.client.gui.helper.LookupHelper;
import pro.gravit.launcher.client.gui.helper.PositionHelper;
import pro.gravit.utils.helper.LogHelper;

public class NotificationDialog
extends AbstractDialog {
    private static final Map<PositionHelper.PositionInfo, NotificationSlotsInfo> slots = new HashMap<PositionHelper.PositionInfo, NotificationSlotsInfo>();
    private String header;
    private String text;
    private Text textHeader;
    private Text textDescription;
    private PositionHelper.PositionInfo positionInfo;
    private NotificationSlot positionSlot;
    private double positionOffset;

    public NotificationDialog(JavaFXApplication application, String header, String text) {
        super("components/notification.fxml", application);
        this.header = header;
        this.text = text;
    }

    @Override
    public String getName() {
        return "notify";
    }

    @Override
    protected void doInit() throws Exception {
        this.textHeader = (Text)LookupHelper.lookup((Node)this.layout, "#notificationHeading");
        this.textDescription = (Text)LookupHelper.lookup((Node)this.layout, "#notificationText");
        this.layout.setOnMouseClicked(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
        });
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        this.setOnClose(() -> {
            if (this.positionSlot != null) {
                NotificationSlotsInfo slotsInfo = slots.get((Object)this.positionInfo);
                slotsInfo.remove(this.positionSlot);
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
    }

    public void setPosition(PositionHelper.PositionInfo position, NotificationSlot positionSlot) {
        NotificationSlotsInfo slotsInfo;
        if (this.positionInfo != null) {
            slotsInfo = slots.get((Object)this.positionInfo);
            slotsInfo.remove(positionSlot);
        }
        this.positionInfo = position;
        LogHelper.info("Notification position: %s", new Object[]{position});
        if (position == null) {
            return;
        }
        slotsInfo = slots.get((Object)position);
        if (slotsInfo == null) {
            slotsInfo = new NotificationSlotsInfo();
            slots.put(position, slotsInfo);
        }
        this.positionSlot = positionSlot;
        this.positionOffset = slotsInfo.add(positionSlot);
    }

    public void setHeader(String header) {
        this.header = header;
        if (this.isInit()) {
            this.textHeader.setText(header);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.isInit()) {
            this.textDescription.setText(text);
        }
    }

    @Override
    public LookupHelper.Point2D getOutSceneCoords(Rectangle2D bounds) {
        if (this.positionInfo == null) {
            LogHelper.info("Notification position: using central");
            return super.getOutSceneCoords(bounds);
        }
        return PositionHelper.calculate(this.positionInfo, this.layout.getPrefWidth(), this.layout.getPrefHeight(), 0.0, 30.0 + this.positionOffset, bounds.getMaxX(), bounds.getMaxY());
    }

    @Override
    public LookupHelper.Point2D getSceneCoords(Pane root) {
        if (this.positionInfo == null) {
            return super.getSceneCoords(root);
        }
        return PositionHelper.calculate(this.positionInfo, this.layout.getPrefWidth(), this.layout.getPrefHeight(), 0.0, 30.0 + this.positionOffset, root.getPrefWidth(), root.getPrefHeight());
    }

    @Override
    public void errorHandle(Throwable e) {
        LogHelper.error(e);
    }

    private static class NotificationSlotsInfo {
        private final LinkedList<NotificationSlot> stack = new LinkedList();

        private NotificationSlotsInfo() {
        }

        double add(NotificationSlot slot) {
            double offset = 0.0;
            for (NotificationSlot slot1 : this.stack) {
                offset += slot1.size;
            }
            this.stack.add(slot);
            return offset;
        }

        void remove(NotificationSlot removeSlot) {
            boolean isFound = false;
            for (NotificationSlot slot : this.stack) {
                if (isFound) {
                    slot.onScroll.accept(removeSlot.size);
                    continue;
                }
                if (removeSlot != slot) continue;
                isFound = true;
            }
            this.stack.remove(removeSlot);
        }
    }

    public static class NotificationSlot {
        public final Consumer<Double> onScroll;
        public final double size;

        public NotificationSlot(Consumer<Double> onScroll, double size) {
            this.onScroll = onScroll;
            this.size = size;
        }
    }
}

