/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.UserSettings;
import pro.gravit.launcher.client.gui.config.GuiModuleConfig;
import pro.gravit.launcher.client.gui.service.JavaService;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.utils.helper.JavaHelper;

public class RuntimeSettings
extends UserSettings {
    public static final LAUNCHER_LOCALE DEFAULT_LOCALE = LAUNCHER_LOCALE.RUSSIAN;
    public transient Path updatesDir;
    @LauncherNetworkAPI
    public String login;
    @LauncherNetworkAPI
    public AuthRequest.AuthPasswordInterface password;
    @Deprecated
    @LauncherNetworkAPI
    public byte[] encryptedPassword;
    @LauncherNetworkAPI
    public boolean autoAuth;
    @LauncherNetworkAPI
    public GetAvailabilityAuthRequestEvent.AuthAvailability lastAuth;
    @LauncherNetworkAPI
    public String updatesDirPath;
    @LauncherNetworkAPI
    public UUID lastProfile;
    @LauncherNetworkAPI
    public LAUNCHER_LOCALE locale;
    @LauncherNetworkAPI
    public String oauthAccessToken;
    @LauncherNetworkAPI
    public String oauthRefreshToken;
    @LauncherNetworkAPI
    public long oauthExpire;
    @LauncherNetworkAPI
    public String theme;
    @LauncherNetworkAPI
    public Map<UUID, ProfileSettings> profileSettings = new HashMap<UUID, ProfileSettings>();
    @LauncherNetworkAPI
    public List<ClientProfile> profiles;

    public static RuntimeSettings getDefault(GuiModuleConfig config) {
        RuntimeSettings runtimeSettings = new RuntimeSettings();
        runtimeSettings.autoAuth = false;
        runtimeSettings.updatesDir = DirBridge.defaultUpdatesDir;
        runtimeSettings.locale = config.locale == null ? LAUNCHER_LOCALE.RUSSIAN : LAUNCHER_LOCALE.valueOf(config.locale);
        return runtimeSettings;
    }

    public void apply() {
        if (this.updatesDirPath != null) {
            this.updatesDir = Paths.get(this.updatesDirPath, new String[0]);
        }
    }

    public static class ProfileSettingsView {
        private final transient ProfileSettings settings;
        public int ram;
        public boolean debug;
        public boolean fullScreen;
        public boolean autoEnter;
        public String javaPath;

        public ProfileSettingsView(ProfileSettings settings) {
            this.ram = settings.ram;
            this.debug = settings.debug;
            this.fullScreen = settings.fullScreen;
            this.autoEnter = settings.autoEnter;
            this.javaPath = settings.javaPath;
            this.settings = settings;
        }

        public void apply() {
            this.settings.ram = this.ram;
            this.settings.debug = this.debug;
            this.settings.autoEnter = this.autoEnter;
            this.settings.fullScreen = this.fullScreen;
            this.settings.javaPath = this.javaPath;
        }
    }

    public static class ProfileSettings {
        @LauncherNetworkAPI
        public int ram;
        @LauncherNetworkAPI
        public boolean debug;
        @LauncherNetworkAPI
        public boolean fullScreen;
        @LauncherNetworkAPI
        public boolean autoEnter;
        @LauncherNetworkAPI
        public String javaPath;

        public static ProfileSettings getDefault(JavaService javaService, ClientProfile profile) {
            ProfileSettings settings = new ProfileSettings();
            ClientProfile.ProfileDefaultSettings defaultSettings = profile.getSettings();
            settings.ram = defaultSettings.ram;
            settings.autoEnter = defaultSettings.autoEnter;
            settings.fullScreen = defaultSettings.fullScreen;
            JavaHelper.JavaVersion version = javaService.getRecommendJavaVersion(profile);
            if (version != null) {
                settings.javaPath = version.jvmDir.toString();
            }
            return settings;
        }
    }

    public static enum LAUNCHER_LOCALE {
        RUSSIAN("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
        ENGLISH("en", "English");

        public final String name;
        public final String displayName;

        private LAUNCHER_LOCALE(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }
}

