/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javax.imageio.ImageIO;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.utils.helper.LogHelper;

public class SkinManager {
    private final JavaFXApplication application;
    private final Map<String, SkinEntry> map = new ConcurrentHashMap<String, SkinEntry>();

    public SkinManager(JavaFXApplication application) {
        this.application = application;
    }

    public void addSkin(String username, URL url) {
        this.map.put(username, new SkinEntry(url));
    }

    public BufferedImage getSkin(String username) {
        SkinEntry entry = this.map.get(username);
        if (entry == null) {
            return null;
        }
        return entry.getFullImage();
    }

    public BufferedImage getSkinHead(String username) {
        SkinEntry entry = this.map.get(username);
        if (entry == null) {
            return null;
        }
        return entry.getHeadImage();
    }

    public javafx.scene.image.Image getFxSkin(String username) {
        SkinEntry entry = this.map.get(username);
        if (entry == null) {
            return null;
        }
        return entry.getFullFxImage();
    }

    public javafx.scene.image.Image getFxSkinHead(String username) {
        SkinEntry entry = this.map.get(username);
        if (entry == null) {
            return null;
        }
        return entry.getHeadFxImage();
    }

    public BufferedImage getScaledSkin(String username, int width, int height) {
        BufferedImage image = this.getSkin(username);
        return SkinManager.scaleImage(image, width, height);
    }

    public BufferedImage getScaledSkinHead(String username, int width, int height) {
        BufferedImage image = this.getSkinHead(username);
        return SkinManager.scaleImage(image, width, height);
    }

    public javafx.scene.image.Image getScaledFxSkin(String username, int width, int height) {
        BufferedImage image = this.getSkin(username);
        return SkinManager.convertToFxImage(SkinManager.scaleImage(image, width, height));
    }

    public static BufferedImage sumBufferedImage(BufferedImage img1, BufferedImage img2) {
        int wid = Math.max(img1.getWidth(), img2.getWidth());
        int height = Math.max(img1.getHeight(), img2.getHeight());
        BufferedImage result = new BufferedImage(wid, height, 2);
        Graphics2D g2 = result.createGraphics();
        Color oldColor = g2.getColor();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, wid, height);
        g2.setColor(oldColor);
        g2.drawImage(img1, null, 0, 0);
        g2.drawImage(img2, null, 0, 0);
        g2.dispose();
        return result;
    }

    public javafx.scene.image.Image getScaledFxSkinHead(String username, int width, int height) {
        BufferedImage image = this.getSkinHead(username);
        if (image == null) {
            return null;
        }
        return SkinManager.convertToFxImage(SkinManager.scaleImage(image, width, height));
    }

    private static BufferedImage scaleImage(BufferedImage origImage, int width, int height) {
        if (origImage == null) {
            return null;
        }
        Image resized = origImage.getScaledInstance(width, height, 2);
        BufferedImage image = new BufferedImage(width, height, 3);
        Graphics2D graphics2D = image.createGraphics();
        graphics2D.drawImage(resized, 0, 0, null);
        graphics2D.dispose();
        return image;
    }

    private static BufferedImage downloadSkin(URL url) {
        BufferedImage bufferedImage;
        block11: {
            HttpURLConnection connection = null;
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.85 Safari/537.36");
            connection.setConnectTimeout(10000);
            connection.connect();
            InputStream input = connection.getInputStream();
            try {
                bufferedImage = ImageIO.read(input);
                if (input == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fnfe) {
                        LogHelper.dev("User texture not found" + fnfe.getMessage());
                        return null;
                    }
                }
                catch (IOException e) {
                    LogHelper.error(e);
                    return null;
                }
            }
            input.close();
        }
        return bufferedImage;
    }

    private static BufferedImage getHeadLayerFromSkinImage(BufferedImage image) {
        int width = image.getWidth();
        int renderScale = width / 64;
        int size = 8 * renderScale;
        int x_offset = 40 * renderScale;
        int y_offset = 8 * renderScale;
        LogHelper.debug("ShinHead debug: W: %d Scale: %d Offset: %d", width, renderScale, size);
        return image.getSubimage(x_offset, y_offset, size, size);
    }

    private static BufferedImage getHeadFromSkinImage(BufferedImage image) {
        int width = image.getWidth();
        int renderScale = width / 64;
        int offset = 8 * renderScale;
        LogHelper.debug("ShinHead debug: W: %d Scale: %d Offset: %d", width, renderScale, offset);
        return image.getSubimage(offset, offset, offset, offset);
    }

    private static javafx.scene.image.Image convertToFxImage(BufferedImage image) {
        if (image == null) {
            return null;
        }
        try {
            return SwingFXUtils.toFXImage((BufferedImage)image, null);
        }
        catch (Throwable e) {
            if (LogHelper.isDebugEnabled()) {
                LogHelper.error(e);
            }
            return SkinManager.convertToFxImageJava8(image);
        }
    }

    private static javafx.scene.image.Image convertToFxImageJava8(BufferedImage image) {
        int bw = image.getWidth();
        int bh = image.getHeight();
        switch (image.getType()) {
            case 2: 
            case 3: {
                break;
            }
            default: {
                BufferedImage converted = new BufferedImage(bw, bh, 3);
                Graphics2D graphics2D = converted.createGraphics();
                graphics2D.drawImage((Image)image, 0, 0, null);
                graphics2D.dispose();
                image = converted;
            }
        }
        WritableImage writableImage = new WritableImage(bw, bh);
        DataBufferInt raster = (DataBufferInt)image.getRaster().getDataBuffer();
        int scan = image.getRaster().getSampleModel() instanceof SinglePixelPackedSampleModel ? ((SinglePixelPackedSampleModel)image.getRaster().getSampleModel()).getScanlineStride() : 0;
        WritablePixelFormat pf = image.isAlphaPremultiplied() ? PixelFormat.getIntArgbPreInstance() : PixelFormat.getIntArgbInstance();
        writableImage.getPixelWriter().setPixels(0, 0, bw, bh, (PixelFormat)pf, raster.getData(), raster.getOffset(), scan);
        return writableImage;
    }

    private static class SkinEntry {
        final URL url;
        final String imageUrl;
        SoftReference<Optional<BufferedImage>> imageRef = new SoftReference<Object>(null);
        SoftReference<Optional<BufferedImage>> avatarRef = new SoftReference<Object>(null);
        SoftReference<Optional<javafx.scene.image.Image>> fxImageRef = new SoftReference<Object>(null);
        SoftReference<Optional<javafx.scene.image.Image>> fxAvatarRef = new SoftReference<Object>(null);

        private SkinEntry(URL url) {
            this.url = url;
            this.imageUrl = null;
        }

        synchronized BufferedImage getFullImage() {
            Optional<BufferedImage> result = this.imageRef.get();
            if (result == null) {
                result = Optional.ofNullable(SkinManager.downloadSkin(this.url));
                this.imageRef = new SoftReference<Optional<BufferedImage>>(result);
            }
            return result.orElse(null);
        }

        synchronized javafx.scene.image.Image getFullFxImage() {
            Optional<javafx.scene.image.Image> result = this.fxImageRef.get();
            if (result == null) {
                BufferedImage image = this.getFullImage();
                if (image == null) {
                    return null;
                }
                result = Optional.ofNullable(SkinManager.convertToFxImage(image));
                this.fxImageRef = new SoftReference<Optional<javafx.scene.image.Image>>(result);
            }
            return result.orElse(null);
        }

        synchronized BufferedImage getHeadImage() {
            Optional<BufferedImage> result = this.avatarRef.get();
            if (result == null) {
                BufferedImage image = this.getFullImage();
                if (image == null) {
                    return null;
                }
                result = Optional.of(SkinManager.sumBufferedImage(SkinManager.getHeadFromSkinImage(image), SkinManager.getHeadLayerFromSkinImage(image)));
                this.avatarRef = new SoftReference<Optional<BufferedImage>>(result);
            }
            return result.orElse(null);
        }

        synchronized javafx.scene.image.Image getHeadFxImage() {
            Optional<javafx.scene.image.Image> result = this.fxAvatarRef.get();
            if (result == null) {
                BufferedImage image = this.getHeadImage();
                if (image == null) {
                    return null;
                }
                result = Optional.ofNullable(SkinManager.convertToFxImage(image));
                this.fxAvatarRef = new SoftReference<Optional<javafx.scene.image.Image>>(result);
            }
            return result.orElse(null);
        }
    }
}

