/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Application;
import pro.gravit.launcher.LauncherEngine;
import pro.gravit.launcher.client.gui.JavaFXApplication;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.utils.LauncherUpdater;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.LogHelper;

public class StdJavaRuntimeProvider
implements RuntimeProvider {
    public static volatile Path updatePath;
    private static final AtomicReference<StdJavaRuntimeProvider> INSTANCE;

    public StdJavaRuntimeProvider() {
        INSTANCE.set(this);
    }

    public static StdJavaRuntimeProvider getInstance() {
        return INSTANCE.get();
    }

    public JavaFXApplication getApplication() {
        return JavaFXApplication.getInstance();
    }

    @Override
    public void run(String[] args) {
        LogHelper.debug("Start JavaFX Application");
        Application.launch(JavaFXApplication.class, (String[])args);
        LogHelper.debug("Post Application.launch method invoked");
        if (updatePath != null) {
            LauncherUpdater.nothing();
            LauncherEngine.beforeExit(0);
            Path target = IOHelper.getCodeSource(LauncherUpdater.class);
            try {
                try (InputStream input = IOHelper.newInput(updatePath);
                     OutputStream output = IOHelper.newOutput(target);){
                    IOHelper.transfer(input, output);
                }
                Files.deleteIfExists(updatePath);
            }
            catch (IOException e) {
                LogHelper.error(e);
                LauncherEngine.forceExit(-109);
            }
            LauncherUpdater.restart();
        }
    }

    @Override
    public void preLoad() {
    }

    protected void registerPrivateCommands() {
        JavaFXApplication application = JavaFXApplication.getInstance();
        if (application != null) {
            application.registerPrivateCommands();
        }
    }

    @Override
    public void init(boolean clientInstance) {
        if (clientInstance) {
            JavaFXApplication.setNoGUIMode(true);
        }
    }

    static {
        INSTANCE = new AtomicReference();
    }
}

