/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.client;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import pro.gravit.launcher.Launcher;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class DirBridge {
    public static final String USE_CUSTOMDIR_PROPERTY = "launcher.usecustomdir";
    public static final String CUSTOMDIR_PROPERTY = "launcher.customdir";
    public static final String USE_OPTDIR_PROPERTY = "launcher.useoptdir";
    public static Path dir;
    public static Path dirStore;
    public static Path dirProjectStore;
    public static Path dirUpdates;
    public static Path defaultUpdatesDir;
    public static boolean useLegacyDir;

    public static void move(Path newDir) throws IOException {
        if (newDir == null) {
            LogHelper.debug("Invalid dir (null)");
            if (LogHelper.isDevEnabled()) {
                LogHelper.dev(LogHelper.toString(new Throwable("Check stack of call DirBridge with null path...")));
            }
            return;
        }
        Path oldUpdates = dirUpdates;
        dirUpdates = newDir;
        LogHelper.dev(newDir.toString());
        IOHelper.move(oldUpdates, dirUpdates);
    }

    public static Path getAppDataDir() throws IOException {
        boolean isCustomDir = Boolean.getBoolean(System.getProperty(USE_CUSTOMDIR_PROPERTY, "false"));
        if (isCustomDir) {
            return Paths.get(System.getProperty(CUSTOMDIR_PROPERTY), new String[0]);
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            boolean isOpt = Boolean.getBoolean(System.getProperty(USE_OPTDIR_PROPERTY, "false"));
            if (isOpt) {
                Path opt = Paths.get("/", new String[0]).resolve("opt");
                if (!IOHelper.isDir(opt)) {
                    Files.createDirectories(opt, new FileAttribute[0]);
                }
                return opt;
            }
            Path local = IOHelper.HOME_DIR.resolve(".minecraftlauncher");
            if (!IOHelper.isDir(local)) {
                Files.createDirectories(local, new FileAttribute[0]);
            }
            return local;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            if (System.getenv().containsKey("appdata")) {
                return Paths.get(System.getenv().get("appdata"), new String[0]).toAbsolutePath();
            }
            if (System.getenv().containsKey("APPDATA")) {
                return Paths.get(System.getenv().get("APPDATA"), new String[0]).toAbsolutePath();
            }
            Path appdata = IOHelper.HOME_DIR.resolve("AppData").resolve("Roaming");
            if (!IOHelper.isDir(appdata)) {
                Files.createDirectories(appdata, new FileAttribute[0]);
            }
            return appdata;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX) {
            Path minecraft = IOHelper.HOME_DIR.resolve("minecraft");
            if (!IOHelper.isDir(minecraft)) {
                Files.createDirectories(minecraft, new FileAttribute[0]);
            }
            return minecraft;
        }
        return IOHelper.HOME_DIR;
    }

    public static Path getLauncherDir(String projectname) throws IOException {
        return DirBridge.getAppDataDir().resolve(projectname);
    }

    public static Path getStoreDir(String projectname) throws IOException {
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            return DirBridge.getAppDataDir().resolve("store");
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            return DirBridge.getAppDataDir().resolve("GravitLauncherStore");
        }
        return DirBridge.getAppDataDir().resolve("minecraftStore");
    }

    public static Path getProjectStoreDir(String projectname) throws IOException {
        return DirBridge.getStoreDir(projectname).resolve(projectname);
    }

    public static Path getGuardDir() {
        return dir.resolve("guard");
    }

    public static Path getGuardDir(JVMHelper.ARCH arch, JVMHelper.OS os) {
        Path dir = DirBridge.getGuardDir().resolve(Launcher.makeSpecialGuardDirName(arch, os));
        try {
            IOHelper.createParentDirs(dir);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return dir;
    }

    public static Path getLegacyLauncherDir(String projectname) {
        return IOHelper.HOME_DIR.resolve(projectname);
    }

    public static void setUseLegacyDir(boolean b) {
        useLegacyDir = b;
    }

    static {
        String projectName = Launcher.getConfig().projectName;
        try {
            dir = DirBridge.getLauncherDir(projectName);
            if (!IOHelper.exists(dir)) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!IOHelper.exists(defaultUpdatesDir = dir.resolve("updates"))) {
                Files.createDirectories(defaultUpdatesDir, new FileAttribute[0]);
            }
            if (!IOHelper.exists(dirStore = DirBridge.getStoreDir(projectName))) {
                Files.createDirectories(dirStore, new FileAttribute[0]);
            }
            if (!IOHelper.exists(dirProjectStore = DirBridge.getProjectStoreDir(projectName))) {
                Files.createDirectories(dirProjectStore, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LogHelper.error(e);
        }
    }
}

