/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import pro.gravit.launcher.BasicLauncherEventHandler;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherAgent;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.ClientLauncherCoreModule;
import pro.gravit.launcher.client.ClientLauncherEntryPoint;
import pro.gravit.launcher.client.ClientLauncherProcess;
import pro.gravit.launcher.client.ClientModuleManager;
import pro.gravit.launcher.client.DirBridge;
import pro.gravit.launcher.client.events.ClientEngineInitPhase;
import pro.gravit.launcher.client.events.ClientExitPhase;
import pro.gravit.launcher.client.events.ClientPreGuiPhase;
import pro.gravit.launcher.console.GetPublicKeyCommand;
import pro.gravit.launcher.console.ModulesCommand;
import pro.gravit.launcher.console.SignDataCommand;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.events.request.FeaturesRequestEvent;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.events.request.GetSecureLevelInfoRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launcher.events.request.SecurityReportRequestEvent;
import pro.gravit.launcher.events.request.SetProfileRequestEvent;
import pro.gravit.launcher.gui.NoRuntimeProvider;
import pro.gravit.launcher.gui.RuntimeProvider;
import pro.gravit.launcher.managers.ClientGsonManager;
import pro.gravit.launcher.managers.ConsoleManager;
import pro.gravit.launcher.modules.events.OfflineModeEvent;
import pro.gravit.launcher.modules.events.PreConfigPhase;
import pro.gravit.launcher.profiles.optional.actions.OptionalAction;
import pro.gravit.launcher.profiles.optional.triggers.OptionalTrigger;
import pro.gravit.launcher.request.Request;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.RequestService;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.ExitRequest;
import pro.gravit.launcher.request.auth.GetAvailabilityAuthRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.auth.SetProfileRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launcher.request.management.FeaturesRequest;
import pro.gravit.launcher.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.request.secure.SecurityReportRequest;
import pro.gravit.launcher.request.update.LauncherRequest;
import pro.gravit.launcher.request.websockets.OfflineRequestService;
import pro.gravit.launcher.request.websockets.StdWebSocketService;
import pro.gravit.launcher.utils.NativeJVMHalt;
import pro.gravit.utils.helper.EnvHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherEngine {
    public static ClientLauncherProcess.ClientParams clientParams;
    public static ClientModuleManager modulesManager;
    public final boolean clientInstance;
    private final AtomicBoolean started = new AtomicBoolean(false);
    public RuntimeProvider runtimeProvider;
    public ECPublicKey publicKey;
    public ECPrivateKey privateKey;

    private LauncherEngine(boolean clientInstance) {
        this.clientInstance = clientInstance;
    }

    public static X509Certificate[] getCertificates(Class<?> clazz) {
        Object[] signers = clazz.getSigners();
        if (signers == null) {
            return null;
        }
        return (X509Certificate[])Arrays.stream(signers).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toArray(X509Certificate[]::new);
    }

    public static void checkClass(Class<?> clazz) throws SecurityException {
        LauncherTrustManager trustManager = Launcher.getConfig().trustManager;
        if (trustManager == null) {
            return;
        }
        X509Certificate[] certificates = LauncherEngine.getCertificates(clazz);
        if (certificates == null) {
            throw new SecurityException(String.format("Class %s not signed", clazz.getName()));
        }
        try {
            trustManager.checkCertificatesSuccess(certificates, trustManager::stdCertificateChecker);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public static void beforeExit(int code) {
        try {
            modulesManager.invokeEvent(new ClientExitPhase(code));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void forceExit(int code) {
        try {
            System.exit(code);
        }
        catch (Throwable e) {
            NativeJVMHalt.haltA(code);
        }
    }

    public static void exitLauncher(int code) {
        LauncherEngine.beforeExit(code);
        LauncherEngine.forceExit(code);
    }

    public static void main(String ... args) throws Throwable {
        JVMHelper.checkStackTrace(LauncherEngine.class);
        JVMHelper.verifySystemProperties(Launcher.class, true);
        EnvHelper.checkDangerousParams();
        LauncherEngine.verifyNoAgent();
        LogHelper.printVersion("Launcher");
        LogHelper.printLicense("Launcher");
        LauncherEngine.checkClass(LauncherEngine.class);
        LauncherEngine.checkClass(LauncherAgent.class);
        LauncherEngine.checkClass(ClientLauncherEntryPoint.class);
        modulesManager = new ClientModuleManager();
        modulesManager.loadModule(new ClientLauncherCoreModule());
        LauncherConfig.initModules(modulesManager);
        modulesManager.initModules(null);
        LauncherEngine.initGson(modulesManager);
        ConsoleManager.initConsole();
        modulesManager.invokeEvent(new PreConfigPhase());
        Launcher.getConfig();
        long startTime = System.currentTimeMillis();
        try {
            new LauncherEngine(false).start(args);
        }
        catch (Exception e) {
            LogHelper.error(e);
            return;
        }
        long endTime = System.currentTimeMillis();
        LogHelper.debug("Launcher started in %dms", endTime - startTime);
        LauncherEngine.exitLauncher(0);
    }

    public static void initGson(ClientModuleManager modulesManager) {
        AuthRequest.registerProviders();
        GetAvailabilityAuthRequest.registerProviders();
        OptionalAction.registerProviders();
        OptionalTrigger.registerProviders();
        Launcher.gsonManager = new ClientGsonManager(modulesManager);
        Launcher.gsonManager.initGson();
    }

    public static void verifyNoAgent() {
    }

    public static RequestService initOffline() {
        OfflineRequestService service = new OfflineRequestService();
        LauncherEngine.applyBasicOfflineProcessors(service);
        OfflineModeEvent event = new OfflineModeEvent(service);
        modulesManager.invokeEvent(event);
        return event.service;
    }

    public static void applyBasicOfflineProcessors(OfflineRequestService service) {
        service.registerRequestProcessor(LauncherRequest.class, r -> new LauncherRequestEvent(false, (String)null));
        service.registerRequestProcessor(CheckServerRequest.class, r -> {
            throw new RequestException("CheckServer disabled in offline mode");
        });
        service.registerRequestProcessor(GetAvailabilityAuthRequest.class, r -> {
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> details = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails>();
            details.add(new AuthLoginOnlyDetails());
            GetAvailabilityAuthRequestEvent.AuthAvailability authAvailability = new GetAvailabilityAuthRequestEvent.AuthAvailability("offline", "Offline Mode", true, details);
            ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability> list = new ArrayList<GetAvailabilityAuthRequestEvent.AuthAvailability>(1);
            list.add(authAvailability);
            return new GetAvailabilityAuthRequestEvent(list);
        });
        service.registerRequestProcessor(JoinServerRequest.class, r -> new JoinServerRequestEvent(false));
        service.registerRequestProcessor(ExitRequest.class, r -> new ExitRequestEvent(ExitRequestEvent.ExitReason.CLIENT));
        service.registerRequestProcessor(SetProfileRequest.class, r -> new SetProfileRequestEvent(null));
        service.registerRequestProcessor(FeaturesRequest.class, r -> new FeaturesRequestEvent());
        service.registerRequestProcessor(GetSecureLevelInfoRequest.class, r -> new GetSecureLevelInfoRequestEvent(null, false));
        service.registerRequestProcessor(SecurityReportRequest.class, r -> new SecurityReportRequestEvent(SecurityReportRequestEvent.ReportAction.NONE));
    }

    public static LauncherEngine clientInstance() {
        return new LauncherEngine(true);
    }

    public static LauncherEngine newInstance(boolean clientInstance) {
        return new LauncherEngine(clientInstance);
    }

    public ECPublicKey getClientPublicKey() {
        return this.publicKey;
    }

    public byte[] sign(byte[] bytes) {
        return SecurityHelper.sign(bytes, this.privateKey);
    }

    public void readKeys() throws IOException, InvalidKeySpecException {
        if (this.privateKey != null || this.publicKey != null) {
            return;
        }
        Path dir = DirBridge.dir;
        Path publicKeyFile = dir.resolve("public.key");
        Path privateKeyFile = dir.resolve("private.key");
        if (IOHelper.isFile(publicKeyFile) && IOHelper.isFile(privateKeyFile)) {
            LogHelper.info("Reading EC keypair");
            this.publicKey = SecurityHelper.toPublicECDSAKey(IOHelper.read(publicKeyFile));
            this.privateKey = SecurityHelper.toPrivateECDSAKey(IOHelper.read(privateKeyFile));
        } else {
            LogHelper.info("Generating EC keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair(new SecureRandom());
            this.publicKey = (ECPublicKey)pair.getPublic();
            this.privateKey = (ECPrivateKey)pair.getPrivate();
            LogHelper.info("Writing EC keypair list");
            IOHelper.write(publicKeyFile, this.publicKey.getEncoded());
            IOHelper.write(privateKeyFile, this.privateKey.getEncoded());
        }
    }

    public void start(String ... args) throws Throwable {
        ClientPreGuiPhase event = new ClientPreGuiPhase(null);
        modulesManager.invokeEvent(event);
        this.runtimeProvider = event.runtimeProvider;
        if (this.runtimeProvider == null) {
            this.runtimeProvider = new NoRuntimeProvider();
        }
        this.runtimeProvider.init(this.clientInstance);
        if (!Request.isAvailable()) {
            RequestService service;
            String address = Launcher.getConfig().address;
            LogHelper.debug("Start async connection to %s", address);
            try {
                service = StdWebSocketService.initWebSockets(address).get();
            }
            catch (Throwable e) {
                if (LogHelper.isDebugEnabled()) {
                    LogHelper.error(e);
                }
                LogHelper.warning("Launcher in offline mode");
                service = LauncherEngine.initOffline();
            }
            Request.setRequestService(service);
            if (service instanceof StdWebSocketService) {
                ((StdWebSocketService)service).reconnectCallback = () -> {
                    LogHelper.debug("WebSocket connect closed. Try reconnect");
                    try {
                        Request.reconnect();
                    }
                    catch (Exception e) {
                        LogHelper.error(e);
                        throw new RequestException("Connection failed", e);
                    }
                };
            }
            service.registerEventHandler(new BasicLauncherEventHandler());
        }
        Objects.requireNonNull(args, "args");
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Launcher has been already started");
        }
        this.readKeys();
        this.registerCommands();
        modulesManager.invokeEvent(new ClientEngineInitPhase(this));
        this.runtimeProvider.preLoad();
        LogHelper.debug("Dir: %s", DirBridge.dir);
        this.runtimeProvider.run(args);
    }

    private void registerCommands() {
        ConsoleManager.handler.registerCommand("getpublickey", new GetPublicKeyCommand(this));
        ConsoleManager.handler.registerCommand("signdata", new SignDataCommand(this));
        ConsoleManager.handler.registerCommand("modules", new ModulesCommand());
    }

    private static /* synthetic */ boolean lambda$verifyNoAgent$4(String e) {
        return e.contains("javaagent");
    }

    private static /* synthetic */ boolean lambda$verifyNoAgent$3(String e) {
        return e != null && !e.isEmpty();
    }
}

