/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherInjectionConstructor;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.client.JavaRuntimeModule;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModulesManager;
import pro.gravit.launcher.serialize.HInput;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;
import pro.gravit.utils.helper.VerifyHelper;

public final class LauncherConfig
extends StreamObject {
    private static final List<byte[]> secureConfigCertificates;
    private static final List<Class<?>> modulesClasses;
    private static final MethodType VOID_TYPE;
    public final String projectName;
    public final int clientPort;
    public final LauncherTrustManager trustManager;
    public final ECPublicKey ecdsaPublicKey;
    public final RSAPublicKey rsaPublicKey;
    public final Map<String, byte[]> runtime;
    public final String secureCheckHash;
    public final String secureCheckSalt;
    public final String passwordEncryptKey;
    public final String runtimeEncryptKey;
    public final String address;
    public String secretKeyClient;
    public String unlockSecret;
    public LauncherEnvironment environment;
    public long buildNumber;

    @LauncherInjectionConstructor
    public LauncherConfig(HInput input) throws IOException, InvalidKeySpecException {
        this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey(input.readByteArray(2048));
        this.rsaPublicKey = SecurityHelper.toPublicRSAKey(input.readByteArray(2048));
        this.secureCheckHash = "MTiennNm8fRrHrN/+KYP6cwqYIGpepNBgfV9kaQ5/7g=";
        this.secureCheckSalt = "3c1a3e31c342f162f436096236c2fecb";
        this.passwordEncryptKey = "4cd7d046325f92d208e9afccf4ae856a";
        this.runtimeEncryptKey = null;
        this.projectName = "TFC_Russia";
        this.clientPort = 32287;
        this.secretKeyClient = "c1459dbaf6d93785";
        try {
            this.trustManager = new LauncherTrustManager(secureConfigCertificates);
        }
        catch (CertificateException e) {
            throw new IOException(e);
        }
        this.address = "wss://launcher.tfc-russia.xyz/api";
        this.environment = LauncherEnvironment.STD;
        Launcher.applyLauncherEnv(this.environment);
        int count = input.readLength(0);
        HashMap localResources = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            String name = input.readString(255);
            VerifyHelper.putIfAbsent(localResources, name, input.readByteArray(2048), String.format("Duplicate runtime resource: '%s'", name));
        }
        this.runtime = Collections.unmodifiableMap(localResources);
        this.unlockSecret = "976d266c70859cd788d07c9762cb5036";
        this.buildNumber = 36L;
    }

    public LauncherConfig(String address, ECPublicKey ecdsaPublicKey, RSAPublicKey rsaPublicKey, Map<String, byte[]> runtime, String projectName) {
        this.address = address;
        this.ecdsaPublicKey = ecdsaPublicKey;
        this.rsaPublicKey = rsaPublicKey;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(runtime));
        this.projectName = projectName;
        this.clientPort = 32148;
        this.environment = LauncherEnvironment.STD;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
        this.trustManager = null;
    }

    public LauncherConfig(String address, Map<String, byte[]> runtime, String projectName, LauncherEnvironment env, LauncherTrustManager trustManager) {
        this.address = address;
        this.runtime = Collections.unmodifiableMap(new HashMap<String, byte[]>(runtime));
        this.projectName = projectName;
        this.clientPort = 32148;
        this.trustManager = trustManager;
        this.rsaPublicKey = null;
        this.ecdsaPublicKey = null;
        this.environment = env;
        this.secureCheckSalt = null;
        this.secureCheckHash = null;
        this.passwordEncryptKey = null;
        this.runtimeEncryptKey = null;
    }

    public static void initModules(LauncherModulesManager modulesManager) {
        for (Class<?> clazz : modulesClasses) {
            try {
                modulesManager.loadModule((LauncherModule)MethodHandles.publicLookup().findConstructor(clazz, VOID_TYPE).invokeWithArguments(Collections.emptyList()));
            }
            catch (Throwable e) {
                LogHelper.error(e);
            }
        }
        modulesClasses.clear();
    }

    @Override
    public void write(HOutput output) throws IOException {
        output.writeByteArray(this.ecdsaPublicKey.getEncoded(), 2048);
        output.writeByteArray(this.rsaPublicKey.getEncoded(), 2048);
        Set<Map.Entry<String, byte[]>> entrySet = this.runtime.entrySet();
        output.writeLength(entrySet.size(), 0);
        for (Map.Entry<String, byte[]> entry : this.runtime.entrySet()) {
            output.writeString(entry.getKey(), 255);
            output.writeByteArray(entry.getValue(), 2048);
        }
    }

    static {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        arrayList.add(Base64.getDecoder().decode("MIIBSTCB8aADAgECAgEAMAoGCCqGSM49BAMCMDgxITAfBgNVBAMMGFRGQ19SdXNzaWEgQXV0b2dlbmVyYXRlZDETMBEGA1UECgwKVEZDX1J1c3NpYTAeFw0yNTA4MDEwMDAwMDBaFw0zNTA3MzAwMDAwMDBaMA0xCzAJBgNVBAMMAmNhMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEC88mRwwZ0V982NYIYy1lttxApPdQH35lIan3lqWw8aXb8THHA7KMIow7J2Dzlkst9f0E9NHUZOjttGEVd6Z0f6MXMBUwEwYDVR0lBAwwCgYIKwYBBQUHAwMwCgYIKoZIzj0EAwIDRwAwRAIgWWVZ1QB4/GUMvqAk5wu54bGbZbk19scdDnxxhPLtup8CIFfnHJufxCEyRIUsE5Eka0Y0ZeU1cPOtgJgEHahAa0Xa"));
        secureConfigCertificates = arrayList;
        ArrayList arrayList2 = new ArrayList(1);
        arrayList2.add(JavaRuntimeModule.class);
        modulesClasses = arrayList2;
        VOID_TYPE = MethodType.methodType(Void.TYPE);
    }

    public static enum LauncherEnvironment {
        DEV,
        DEBUG,
        STD,
        PROD;

    }
}

